﻿///
/// 各アーカイブ形式に対応したハンドラの情報を保持するクラスのヘッダファイル。
///

#if       !defined(INCLUDED_SZ_ARCHIVE_HANDLER)
#define            INCLUDED_SZ_ARCHIVE_HANDLER

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

struct CArcInfoEx;

SZ_NS_BEG(szpp)

/// <summary>
/// コーデックマネージャが管理しているハンドラリストのインデックス型。
/// </summary>
typedef int ArchiveHandlerIndex;

/// <summary>
/// 各アーカイブ形式に対応したハンドラの情報を保持するクラス。
/// </summary>
class SZ_SPEC ArchiveHandler
{
public:

  /// <summary>
  /// ハンドラの名称を表す文字列を返すメソッド。
  /// </summary>
  const szchar *GetName() const;

  /// <summary>
  /// ハンドラが圧縮をサポートするかどうかを返すメソッド。
  /// </summary>
  /// <remarks>
  /// 正確には、圧縮／非圧縮を問わず、とにかく該当アーカイブ形式での出力をサポートしているかどうかを返す。
  /// </remarks>
  bool CanCompress() const;

  /// <summary>
  /// フォーマットに対応したハンドラのインデックスを返すメソッド。
  /// </summary>
  ArchiveHandlerIndex GetIndex() const { return index; }

  /// <summary>
  /// フォーマットに対応したハンドラのインデックスで初期化するコンストラクタ。
  /// </summary>
  /// <remarks>
  /// SevenZip++ 内部から呼び出すので、クライアントコードからアクセスする必要はない。
  /// </remarks>
  ArchiveHandler(ArchiveHandlerIndex index, const CArcInfoEx &info);

  /// <summary>
  /// 7-Zip ソースツリーのコーデック情報を表す構造体の参照を返すメソッド。
  /// </summary>
  /// <remarks>
  /// SevenZip++ 内部から呼び出すので、クライアントコードからアクセスする必要はない。
  /// </remarks>
  const CArcInfoEx  &GetHandlerInfo() const { return info; }

  /// <summary>
  /// インスタンスのクローンのポインタを返すメソッド。
  /// </summary>
  /// <remarks>
  /// 当然クローンのメモリを解放するのは呼び出し側の責任となる。
  /// </remarks>
  ArchiveHandler * Clone() const { return new ArchiveHandler(index, info); }

private:

  ArchiveHandlerIndex index;
  const CArcInfoEx  &info;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_HANDLER)
